//Jacek Matulewski, e-mail: jacek@fizyka.umk.pl

#ifndef PDB_H
#define PDB_H

#include <fstream>
#include <stdexcept>

#include "Wektor.h"

/*******************************************************/
/***********************   ATOM   **********************/
/*******************************************************/

//odpowiada linii z pliku PDB
struct Atom
{	
	public:
		//metody statyczne
		static bool CzyRekordZDanymi(const char* pdbRecord);
        static char* WyodrebnijSymbolPierwiastka(const char* name,char* elementSymbol);

		//pola, nazwy pol zgodne z nazwami z dokumentacji pliku PDB
        char* pdbRecord;
        char recordName[7]; //dodatkowy znak na \0
        int serial;
        char name[5];
        char altLoc;
        char resName[4];
        char chainID;
        int resSeq;
        char iCode;
        double X;
        double Y;
        double Z;
        double occupancy;
        double tempFactor;
        char element[3];
        double charge;
	
		//konstruktor, destruktor i metody publiczne
        Atom(const char* pdbRecord);
        ~Atom();
        Wektor Polozenie() const;

	private:
		//metody prywatne
        void ParsujRekord(const char* pdbRecord);

};

/*******************************************************/
/************************   PDB   **********************/
/*******************************************************/

class PDB
{
    private:
        //metody statyczne
		static bool CzyMarkerKoncaKlatki(const char* pdbRecord);

		//pola
		const char* nazwaPliku;
        int iloscWierszyDanych; //ilosc atomow
        Atom** atomy; //atomy z jednej klatki

		//metody prywatne
        void AnalizaPliku();
        void CzytajDaneZPliku();

    public:
		//konstruktor, destruktor i metody publiczne
        PDB(const char *filename);
        ~PDB();
        int LiczbaAtomow() const;
        Atom* PobierzAtom(int indeks) const;
        Wektor SrodekMasy() const;
        bool CzyOstatniaKlatka() const;

        //operator do odczytu atomow
        Atom* operator[](int indeks) const {return PobierzAtom(indeks);}
};

#endif
